import java.lang.*;
import java.util.*;

public class RunFiniteStates
{
	Vector CurrentFiniteStates = new Vector();
	int vectorSize = 0;
	int machineLength = 8;

	public static void main(String[] args)
	{
		int numStates;
		if (args.length > 0)
		{
			numStates = new Integer(args[0]).intValue();
		}
		else
		{
			numStates = new Random().nextInt(10);
		}

		RunFiniteStates runEm = new RunFiniteStates();
		runEm.generateStates(numStates);
		runEm.rankStates();
		runEm.evolveStates();
	}

	public void rankStates()
	{
		for (int i = 0; i < vectorSize; i++)
		{
			System.out.println(((FiniteStates) CurrentFiniteStates.elementAt(i)).toString() + " " + ((FiniteStates) CurrentFiniteStates.elementAt(i)).playMachine(0,0));
		}
	}

	public void evolveStates()
	{
		for (int i = 0; i < (vectorSize - 1); i=i+2)
		{
			String parent1 = ((FiniteStates) CurrentFiniteStates.elementAt(i)).toString();
			String parent2 = ((FiniteStates) CurrentFiniteStates.elementAt(i+1)).toString();

			System.out.println("Method One");
			String childOne = parent1.substring(0,parent1.length()/2) + parent2.substring(parent2.length()/2,parent2.length());
			System.out.println(((FiniteStates) CurrentFiniteStates.elementAt(i)).toString() + " " + ((FiniteStates) CurrentFiniteStates.elementAt(i)).playMachine(0,0));
			System.out.println(((FiniteStates) CurrentFiniteStates.elementAt(i+1)).toString() + " " + ((FiniteStates) CurrentFiniteStates.elementAt(i+1)).playMachine(0,0));
			FiniteStates childOneFiniteStates = new FiniteStates(childOne);
			System.out.println(childOneFiniteStates.toString() + " " + childOneFiniteStates.playMachine(0,0));
			System.out.println();

			System.out.println("Method Two");
			String childTwo = parent2.substring(0,parent2.length()/2) + parent1.substring(parent1.length()/2,parent1.length());
			System.out.println(((FiniteStates) CurrentFiniteStates.elementAt(i)).toString() + " " + ((FiniteStates) CurrentFiniteStates.elementAt(i)).playMachine(0,0));
			System.out.println(((FiniteStates) CurrentFiniteStates.elementAt(i+1)).toString() + " " + ((FiniteStates) CurrentFiniteStates.elementAt(i+1)).playMachine(0,0));
			FiniteStates childTwoFiniteStates = new FiniteStates(childTwo);
			System.out.println(childTwoFiniteStates.toString() + " " + childTwoFiniteStates.playMachine(0,0));
			System.out.println();

			System.out.println("Method Three");
			StringBuffer childThree = new StringBuffer();
			for (int p = 0; p < parent1.length(); p=p+machineLength)
			{
				if (new Integer(parent1.substring(p,p+machineLength)).intValue() > new Integer(parent2.substring(p,p+machineLength)).intValue())
				{
					childThree.append(parent1.substring(p,p+machineLength));
				}
				else
				{
					childThree.append(parent2.substring(p,p+machineLength));
				}
			}
			FiniteStates childThreeFiniteStates = new FiniteStates(childThree.toString());

			System.out.println(((FiniteStates) CurrentFiniteStates.elementAt(i)).toString() + " " + ((FiniteStates) CurrentFiniteStates.elementAt(i)).playMachine(0,0));
			System.out.println(((FiniteStates) CurrentFiniteStates.elementAt(i+1)).toString() + " " + ((FiniteStates) CurrentFiniteStates.elementAt(i+1)).playMachine(0,0));
			System.out.println(childThreeFiniteStates.toString() + " " + childThreeFiniteStates.playMachine(0,0));
			System.out.println();

			System.out.println("Method Four");
			StringBuffer childFour = new StringBuffer();
			for (int p = 0; p < parent1.length(); p++)
			{
				if (new Integer(parent1.substring(p,p+1)).intValue() > new Integer(parent2.substring(p,p+1)).intValue())
				{
					childFour.append(parent1.substring(p,p+1));
				}
				else
				{
					childFour.append(parent2.substring(p,p+1));
				}
			}
			FiniteStates childFourFiniteStates = new FiniteStates(childFour.toString());

			System.out.println(((FiniteStates) CurrentFiniteStates.elementAt(i)).toString() + " " + ((FiniteStates) CurrentFiniteStates.elementAt(i)).playMachine(0,0));
			System.out.println(((FiniteStates) CurrentFiniteStates.elementAt(i+1)).toString() + " " + ((FiniteStates) CurrentFiniteStates.elementAt(i+1)).playMachine(0,0));
			System.out.println(childFourFiniteStates.toString() + " " + childFourFiniteStates.playMachine(0,0));
			System.out.println();

			System.out.println("Different Start Points, Method 4");
			// Assuming 10 Machines
			for (int s = 0; s < 10; s++)
			{
				for (int q = 0; q < 2; q++)
				{
					System.out.println("Starting Point: " + s + " State: " + q + " " + childFourFiniteStates.playMachine(s,q));
				}
			}


		}

	}

	public void generateStates(int numStates)
	{
		Random theRanGen = new Random();

		// 5 States
		for (int p = 0; p < numStates; p++)
		{
			StringBuffer theRanString = new StringBuffer();

			// 10 Machines
			for (int i = 0; i < 10; i++)
			{
				// Object
				theRanString.append(theRanGen.nextInt(10));

				// State One Next Object Index
				theRanString.append(theRanGen.nextInt(10));
				// State One Next Object State
				theRanString.append(theRanGen.nextInt(2));

				// State Two Next Object Index
				theRanString.append(theRanGen.nextInt(10));
				// State Two Next Object State
				theRanString.append(theRanGen.nextInt(2));

				// Attribute One
				theRanString.append(theRanGen.nextInt(4));
				// Attribute Two
				theRanString.append(theRanGen.nextInt(4));
				// Attribute Three
				theRanString.append(theRanGen.nextInt(10));

			}

			String theString = theRanString.toString();

			FiniteStates theFiniteStates = new FiniteStates(theString);
			//System.out.println(theFiniteStates.playMachine(0,0));

			CurrentFiniteStates.add(theFiniteStates);
			vectorSize++;
		}
	}
}